/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.run;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.plugins.TransformPluginType;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;

public class MainBeam {
    public static void main(String[] args) {
        try {
            HopEnvironment.init();
            String pipelineMetaXml = "";
            String metadataJson = "";
            String runConfigName = "";
            if (args[0].startsWith("--")) {
                block12: for (int i = 0; i < args.length; ++i) {
                    String value;
                    String[] split = args[i].split("=", 2);
                    String key = split.length > 0 ? split[0] : null;
                    String string = value = split.length > 1 ? split[1] : null;
                    if (key == null) continue;
                    switch (key) {
                        case "--HopPipelinePath": {
                            System.out.println("Argument 1 : Pipeline filename (.hpl)   : " + value);
                            pipelineMetaXml = MainBeam.readFileIntoString(value, "UTF-8");
                            continue block12;
                        }
                        case "--HopMetadataPath": {
                            System.out.println("Argument 2 : Metadata filename (.json)  : " + value);
                            metadataJson = MainBeam.readFileIntoString(value, "UTF-8");
                            continue block12;
                        }
                        case "--HopRunConfigurationName": {
                            System.out.println("Argument 3 : Pipeline run configuration : " + value);
                            runConfigName = value;
                        }
                    }
                }
            } else {
                System.out.println("Argument 1 : Pipeline filename (.hpl)   : " + args[0]);
                pipelineMetaXml = MainBeam.readFileIntoString(args[0], "UTF-8");
                System.out.println("Argument 2 : Metadata filename (.json)  : " + args[1]);
                metadataJson = MainBeam.readFileIntoString(args[1], "UTF-8");
                System.out.println("Argument 3 : Pipeline run configuration : " + args[2]);
                runConfigName = args[2];
                System.out.println(">>>>>> Initializing Hop...");
            }
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineRunConfiguration.class);
            if (!serializer.exists(runConfigName)) {
                throw new HopException("The specified pipeline run configuration '" + runConfigName + "' doesn't exist");
            }
            System.out.println(">>>>>> Loading pipeline metadata");
            PipelineMeta pipelineMeta = new PipelineMeta(XmlHandler.loadXmlString((String)pipelineMetaXml, (String)"pipeline"), (IHopMetadataProvider)metadataProvider);
            System.out.println(">>>>>> Building Apache Beam Pipeline...");
            PluginRegistry registry = PluginRegistry.getInstance();
            IPlugin beamInputPlugin = registry.getPlugin(TransformPluginType.class, "BeamInput");
            if (beamInputPlugin == null) {
                throw new HopException("ERROR: Unable to find Beam Input transform plugin. Is it in the fat jar? ");
            }
            System.out.println(">>>>>> Found Beam Input transform plugin class loader");
            IVariables variables = Variables.getADefaultVariableSpace();
            IPipelineEngine pipelineEngine = PipelineEngineFactory.createPipelineEngine((IVariables)variables, (String)runConfigName, (IHopMetadataProvider)metadataProvider, (PipelineMeta)pipelineMeta);
            System.out.println(">>>>>> Pipeline executing starting...");
            pipelineEngine.execute();
            pipelineEngine.waitUntilFinished();
            System.out.println(">>>>>> Execution finished...");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Error running Beam pipeline: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static String readFileIntoString(String filename, String encoding) throws IOException {
        String string;
        block8: {
            InputStream inputStream = HopVfs.getInputStream((String)filename);
            try {
                string = IOUtils.toString((InputStream)inputStream, (String)encoding);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Error reading from file " + filename, e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

